/**
* \file: AditCoreSurrogateChannel.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Sample channel implementation for connection setup callbacks
*
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef BDCL_ADITCORESURROGATECHANNEL_H
#define BDCL_ADITCORESURROGATECHANNEL_H

#include <bdcl/AditBaiduCore.h>
#include <bdcl/AditCoreSurrogate.h>
#include <bdcl/BaiduCoreCallbackDealer.h>

namespace adit { namespace bdcl {

class AditCoreSurrogate;

class AditCoreSurrogateChannel : public IAditBaiduCoreCallbacks
{
public:
    AditCoreSurrogateChannel(CoreCallbackDealer* mCallbackDealer);
    ~AditCoreSurrogateChannel();

    AditCoreSurrogate* mCoreSurrogate;
private:

    unsigned int mCounter;
    void createEvent(std::string inString);
    virtual void onProtocolVersionMatchStatus(bool inMatchStatus);

    virtual void onAuthenticationResponse(bool inResponse);

    virtual void onError(bdclErrorCodes inErrorCode);
};

} } /* namespace adit { namespace bdcl { */

#endif /* BDCL_ADITCORESURROGATECHANNEL_H */
